unit untTest;

interface

// Menu - Component
// - Import Component
// - Import Type library
// - Zoek de nieuwste versie
// - opslaan als unit in deze map VTLB2_TLB.pas.
// - verwijzing naar  xsl aanpassen en in juiste map

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Dateedit;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    DateEdit1: TDateEdit;
    Leeftijd: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Memo1: TMemo;
    ListBox1: TListBox;
    DateEdit2: TDateEdit;
    Label3: TLabel;
    Ophalen: TButton;
    Button3: TButton;
    Edit3: TEdit;
    Edit4: TEdit;
    DateEdit3: TDateEdit;
    Edit5: TEdit;
    cbxPartner: TCheckBox;
    ddtDatumBerekening: TDateEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OphalenClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  VTLB2_TLB, System.UITypes,
  Registry;

{$R *.dfm}

// Globale routines
function RightFill(S: string; X: integer; C: char): string;
begin
  Result := Trim(S);
  while Length(Result) < X do
    Result := C + Result;
  Result := Copy(Result, Length(S) - X + 1, X);
end;

function StrToDatum(Datum: string): integer;
var
  S: string;
begin
  try
    Datum := DateToStr(StrToDate(Datum));
  except
    Result := 0;
    exit;
  end;
  if Length(Datum) <> 10 then
  begin
    Result := 0;
    exit;
  end;
  S := Copy(Datum, 7, 4) + Copy(Datum, 4, 2) + Copy(Datum, 1, 2);
  try
    Result := StrToInt(S);
  except
    Result := 0;
  end;
end;

function DatumToStr(Datum: integer): string;
var
  S: string;
begin
  try
    S := IntToStr(Datum);
  except
    Result := '';
    exit;
  end;
  if Length(S) <> 8 then
  begin
    Result := '';
    exit;
  end;
  Result := Copy(S, 7, 2) + '-' + Copy(S, 5, 2) + '-' + Copy(S, 1, 4);
  // Geldige datum????
  try
    StrToDate(Result);
  except
    Result := '';
    exit;
  end;
end;

function Vandaag: integer;
begin
  Result := StrToDatum(DateToStr(Date));
end;

function GeefDag(iDatum: integer): integer;
begin
  Result := 0;
  if iDatum = 0 then
    exit;
  try
    Result := StrToInt(Copy(IntToStr(iDatum), 7, 2));
  except
  end;
end;

function GeefMaand(iDatum: integer): integer;
begin
  Result := 0;
  if iDatum = 0 then
    exit;
  try
    Result := StrToInt(Copy(IntToStr(iDatum), 5, 2));
  except
  end;
end;

function GeefJaar(iDatum: integer): integer;
begin
  Result := 0;
  if iDatum = 0 then
    exit;
  try
    Result := StrToInt(Copy(IntToStr(iDatum), 1, 4));
  except
  end;
end;

function DagenInMaand(Mo, Ye: word): integer;
begin
  if Mo in [1, 3, 5, 7, 8, 10, 12] then
    Result := 31
  else if Mo in [4, 6, 9, 11] then
    Result := 30
  else if IsLeapYear(Ye) then
    Result := 29
  else
    Result := 28;
end;

function GeefDatum(iJaar, iMaand, iDag: integer): integer;
begin
  if iDag > DagenInMaand(iMaand, iJaar) then
    iDag := DagenInMaand(iMaand, iJaar);
  Result := StrToInt(IntToStr(iJaar) + RightFill(IntToStr(iMaand), 2, '0') + RightFill(IntToStr(iDag), 2, '0'));
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  VTLB: VTLB2_TLB.VTLBBerekening;
  Ver: TVersieRecord;
begin
  VTLB := CoVTLBBerekening.Create;
  VTLB.GeefVersieInformatie(Ver);
  Memo1.Clear;
  Memo1.Lines.Add(format('Plug-in Versie: %d.%d.%d', [Ver.berPlugInVersieMajor, Ver.berPlugInVersieMinor, Ver.berPlugInVersieRelease]));
  Memo1.Lines.Add(format('Ingangsdatum: %s', [DatumToStr(Ver.berPlugInIngangsDatum)]));
  Memo1.Lines.Add(format('Eerste berekeningsversie: %s', [DatumToStr(Ver.berEersteBerekeningsVersie)]));
  Memo1.Lines.Add(format('Laatste berekeningsversie: %s', [DatumToStr(Ver.berLaatsteBerekeningsVersie)]));
  // Vrijgeven is niet nodig
  // Als alle referenties naar VTLB verdwijnen wordt deze vrijgegeven.
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  VTLB: VTLBBerekening;
  Inv: TInvoerRecord;
  Uit: TUitvoerRecord;
  Knd: TKindRecord;
  R: integer;
  Reg: TRegistry;
  bTonen: Boolean;
  sXsl: WideString;
  sXml, sNaam, sInsol, sToel: WideString;
  vtlbEI: TVTLBExtra;

begin
  bTonen := False;
  if Sender = Button3 then
    bTonen := True;
  VTLB := CoVTLBBerekening.Create;

  // Invoer record init
  VTLB.InitialiseerInvoer(Inv);

  // Kinderen toevoegen
  Knd.GeboorteDatum := GeefDatum(GeefJaar(Vandaag) - 16, GeefMaand(Vandaag), GeefDag(Vandaag));
  Knd.SoortOnderwijs := TSoortOnderwijs_soVOOnderbouw;
  VTLB.KindAdd(Knd);
  Knd.GeboorteDatum := GeefDatum(GeefJaar(Vandaag) - 17, GeefMaand(Vandaag), GeefDag(Vandaag));
  Knd.SoortOnderwijs := TSoortOnderwijs_soGeen;
  VTLB.KindAdd(Knd);
  Knd.GeboorteDatum := GeefDatum(GeefJaar(Vandaag) - 18, GeefMaand(Vandaag), GeefDag(Vandaag));
  Knd.SoortOnderwijs := TSoortOnderwijs_soVOBovenbouw;
  VTLB.KindAdd(Knd);
  Knd.GeboorteDatum := GeefDatum(GeefJaar(Vandaag) - 22, GeefMaand(Vandaag), GeefDag(Vandaag));
  Knd.SoortOnderwijs := TSoortOnderwijs_soVOOnderbouw;
  VTLB.KindAdd(Knd);
  // Belangrijk! Aantal inwonende kinderen moet gelijk zijn aan KindCount!!
  Inv.kndInwonendAantal := VTLB.KindCount;

  // Geboortedatum vullen
  Inv.schGeboortedatum := StrToDatum(DateEdit1.Text);
  Inv.schInkAOW := 225;
  Inv.schInkAOWEx.Netto := 200;
  Inv.schInkAOWEx.Vakantiegeld := 20;
  Inv.schInkANW := 115;
  Inv.schInkANWEx.Netto := 100;
  Inv.schInkANWEx.Vakantiegeld := 10;

  Inv.schInkKinderopvangtoeslagRijk := 67;
  Inv.schInkKinderopvangtoeslag := 120;
  Inv.schUitgKinderopvangNoodzaak := TJaNee_jnJa;
  Inv.schUitgKinderopvangKosten := 400.76;

  Inv.berDatumBerekening := StrToDatum(ddtDatumBerekening.Text);
  Inv.berBerekeningsversie := StrToDatum(ddtDatumBerekening.Text);

  if cbxPartner.Checked then
  begin
    Inv.parGeboortedatum := GeefDatum(GeefJaar(Vandaag) - 35, GeefMaand(Vandaag), GeefDag(Vandaag));
    Inv.schPartnerAanwezig := TJaNee_jnJa;
    Inv.parOpgenomenInInrichting := TJaNee_jnNee;
    Inv.parInkomenBekend := TJaNee_jnJa;
    Inv.schToeslagPartners := TJaNee_jnNee;
    Inv.schGemeenschapVanGoederen := TJaNee_jnJa;
    Inv.schJaarHuwelijk := 2018;
  end;

  Inv.schUitgCorrectieBeschermBudget := 8.76;
  Inv.parUitgCorrectieBeschermBudget := 13.98;

  Inv.schUitgAutoNoodzakelijk := TJaNee_jnJa;
  Inv.schUitgAantalKmPerJaar := 10000;

  if bTonen then
  begin
    // sXsl := 'http://helpdesk.kredit.nl/All_Help/Downloads/VTLB/VTLBCalculator 1.9.1.xsl';
    sXsl := 'VTLBCalculator 5.0.xsl';
    sXml := 'MijnVTLBBerekeningen.xml';
    sNaam := Edit3.Text;
    sInsol := Edit4.Text;
    sToel := Edit5.Text;
    vtlbEI.xslNaam := PAnsiChar(AnsiString(sXsl));
    vtlbEI.schNaam := PAnsiChar(AnsiString(sNaam));
    vtlbEI.schInsolventieNr := PAnsiChar(AnsiString(sInsol));
    vtlbEI.schDatumToepWSNP := StrToDatum(DateEdit3.Text);
    vtlbEI.schStartdatumLptWsnp := StrToDatum(DateEdit3.Text);
    vtlbEI.schToelichting := PAnsiChar(AnsiString(sToel));
    vtlbEI.xmlNaam := PAnsiChar(AnsiString(sXml));
    // vtlbEi.berGeldigVan := GeefDatum(GeefJaar(Vandaag)-1, GeefMaand(Vandaag), GeefDag(Vandaag));
    // vtlbEi.berGeldigTem := GeefDatum(GeefJaar(Vandaag)+1, GeefMaand(Vandaag), GeefDag(Vandaag));
    vtlbEI.xmlTonen := TJaNee_jnJa;
    vtlbEI.srcVersie := '0.1';
    vtlbEI.srcRelease := '1';
    R := VTLB.ToonVTLBBerekening(Inv, Uit, vtlbEI);
  end
  else
  begin
    // Berekening uitvoeren
    R := VTLB.MaakVTLBBerekening(Inv, Uit);
  end;

  if R <> 0 then
  begin
    try
      if Uit.berFoutCode <> 0 then
      begin
        // Uitregister halen
        Reg := TRegistry.Create;
        try
          Reg.RootKey := HKEY_CURRENT_USER;
          if Reg.OpenKey('Software\Kred''IT\Vtlb.dll\Melding', False) then
          begin
            MessageDlg(Reg.ReadString('FoutMelding') + #13 + #13 + 'Details:' + #13 + 'Foutcode: ' + #9 + IntToStr(Uit.berFoutCode) +
              ' (chk#' + IntToStr(Reg.ReadInteger('Foutcode')) + ')' + #13#10 + 'Foutlocatie: ' + #9 + Reg.ReadString('Foutlocatie') +
              ' (Nummer: ' + IntToStr(Reg.ReadInteger('FoutlocatieNr')) + ')' + #13#10 + 'Systeemmelding: ' + #9 +
              Reg.ReadString('SysMelding') + #13#10 + 'Tijdstip: ' + #9 + #9 + Reg.ReadString('Tijdstip'), mtInformation, [mbOK], 0);
            Reg.CloseKey;
          end
          else
            MessageDlg(IntToStr(Uit.berFoutCode) + #13 + 'Foutmelding kon niet uit het register worden gelezen.', mtError, [mbOK], 0);
        finally
          Reg.Free;
        end;
      end
    except
      on E: Exception do
      begin
        MessageDlg('Lezen register is niet gelukt!' + #13 + #13 + 'FoutCode VTLB Plug-in: ' + IntToStr(Uit.berFoutCode) + '.' + #13 + #13 +
          'Details:' + #13 + E.Message, mtInformation, [mbOK], 0);
        Uit.berFoutCode := -MAXINT;
      end; // except
    end; // try
  end;

  // Resultaat op scherm
  Edit1.Text := IntToStr(Uit.schLeeftijd);
  Edit2.Text := IntToStr(Uit.kndAantalInwonend);
  // Vrijgeven is niet nodig
  // Als alle referenties naar VTLB verdwijnen wordt deze vrijgegeven.
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FormatSettings.DateSeparator := '-'; { Char; }
  FormatSettings.ShortDateFormat := 'dd-MM-yyyy'; { string[15]; }
  FormatSettings.TimeSeparator := ':'; { Char; }
  FormatSettings.ShortTimeFormat := 'hh:mm'; { string[15]; }
  FormatSettings.LongTimeFormat := 'hh:mm:ss'; { string[31]; }
  ddtDatumBerekening.Date := Date;
  DateEdit2.Date := Date;

end;

procedure TForm1.OphalenClick(Sender: TObject);
var
  VTLB: VTLBBerekening;
  I: integer;
  iDat: integer;
  dWaarde: double;
begin
  VTLB := CoVTLBBerekening.Create;

  ListBox1.Clear;
  iDat := StrToDatum(DateEdit2.Text);
  for I := 1 to 200 - 1 do
    if VTLB.GeefParameterWaarde(iDat, I, dWaarde) = 0 then
    begin
      ListBox1.Items.Add(IntToStr(I) + ' - ' + FloatToStr(dWaarde));
    end
    else
      break;
end;

end.
